unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, CheckLst;

type
  TMainForm = class(TForm)
    CheckListBox1: TCheckListBox;
    Panel1: TPanel;
    imgKONIEC: TImage;
    imgSPR: TImage;
    procedure imgSPRClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure imgKONIECClick(Sender: TObject);

  private

  public
    procedure Koniec();

  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.imgKONIECClick(Sender: TObject);
begin
	Koniec();
end;

procedure TMainForm.Koniec();
begin
	if Application.MessageBox('Koniec pracy', 'Uwaga', MB_ICONINFORMATION or MB_YESNO) = mrYes then
	begin
		Close();
   end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
	fn   : String;
	txt  : String;
	znak : String;
   lp   : Integer;

begin
	fn := ExtractFilePath(Application.ExeName) + 'woj.txt';
   if FileExists(fn) then
   begin
   	CheckListBox1.Items.LoadFromFile(fn);
   end;


	txt  := '';
	znak := '';
   lp   := 0;

   for lp := 0 to CheckListBox1.Count-1 do
   begin
		txt := CheckListBox1.Items.Strings[lp];
      txt:= Copy(txt,1 ,1);

      if (txt = 'm') then
      begin
			CheckListBox1.Checked[lp] := true;
      end;
   end;
end;

procedure TMainForm.imgSPRClick(Sender: TObject);
var
	kom  : String;
   ilEL : Integer;
	lp   : Integer;

begin
	kom  := '';
	ilEL := CheckListBox1.Items.Count;

   if ilEL > 0 then
   begin
   	for lp := 0 to ilEl-1 do
      begin
			if CheckListBox1.Checked[lp] then
         begin
            kom := kom + IntToStr(lp) + ' ' + CheckListBox1.Items[lp] + #10#13;
         end;
      end;

      if kom <> '' then
      begin
	      ShowMessage('Zaznaczone pozycje: ' + #10#13 + kom);
      end;
   end;
end;

end.
